#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/castle_grounds/header.h"
extern u8 _castle_grounds_segment_ESegmentRomStart[];
extern u8 _castle_grounds_segment_ESegmentRomEnd[];

const LevelScript level_castle_grounds_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _castle_grounds_segment_7SegmentRomStart, _castle_grounds_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _castle_groundsSegmentRomStart, _castle_groundsSegmentRomEnd),
LOAD_RAW(0x0E, _castle_grounds_segment_ESegmentRomStart, _castle_grounds_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group10_mio0SegmentRomStart, _group10_mio0SegmentRomEnd),
LOAD_RAW(12, _group10_geoSegmentRomStart, _group10_geoSegmentRomEnd),
LOAD_MIO0(6, _group15_mio0SegmentRomStart, _group15_mio0SegmentRomEnd),
LOAD_RAW(13, _group15_geoSegmentRomStart, _group15_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_03,           castle_grounds_geo_0006F4),
LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_BUBBLY_TREE,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_WARP_PIPE,    warp_pipe_geo),
LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_CASTLE_DOOR,  castle_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_METAL_DOOR,   metal_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_VCUTM_GRILL,  castle_grounds_geo_00070C),
LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_FLAG,         castle_grounds_geo_000660),
LOAD_MODEL_FROM_GEO(MODEL_CASTLE_GROUNDS_CANNON_GRILL, castle_grounds_geo_000724),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
LOAD_MODEL_FROM_GEO(41,  metal_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_11),
JUMP_LINK(script_func_global_16),
JUMP_LINK(local_area_castle_grounds_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 180, /* pos */ 0, -2500, 3750),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_castle_grounds_1_[] = {
AREA(1, Geo_castle_grounds_1_0x1910200),
TERRAIN(col_castle_grounds_1_0xe027fc0),
SET_BACKGROUND_MUSIC(0, 0),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_castle_grounds_1_),
JUMP_LINK(local_warps_castle_grounds_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_castle_grounds_1_[] = {
OBJECT_WITH_ACTS(0, 0, -2250, 1500, 0, 180, 0, 0x10000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 0, -2500, -850, 0, 0, 0, 0x26140000,  bhvWarp, 31),
OBJECT_WITH_ACTS(0, 0, -2500, -350, 0, 0, 0, 0x320000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(22, 463, 6915, 6776, 0, 0, 0, 0x150000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(0, 142, 7015, 6381, 0, 0, 0, 0x290000,  bhvDeathWarp, 31),
OBJECT_WITH_ACTS(0, 142, 7427, 6381, 0, 0, 0, 0x330000,  bhvAirborneStarCollectWarp, 31),
OBJECT_WITH_ACTS(201, 0, 5002, -200, 0, 0, 0, 0x0,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(137, 1250, 5300, -2500, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 0, 5000, -1800, 0, 0, 0, 0x340000,  bhvInstantActiveWarp, 31),
OBJECT_WITH_ACTS(0, 0, 4000, -2500, 0, 0, 0, 0x32160000,  bhvWarp, 31),
OBJECT_WITH_ACTS(23, -5119, -2500, 213, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -4535, -2500, 2139, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -3221, -2500, 3773, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 5828, -2500, -1249, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 5371, -2500, 1118, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 1916, -2500, 3850, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 4140, -2500, 3235, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -1077, -2500, 4518, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, -5119, -1660, 213, 0, 0, 0, 0x2020000,  bhvHidden1upInPoleSpawner, 31),
OBJECT_WITH_ACTS(0, -5119, -1900, 213, 0, 0, 0, 0x0,  bhvHidden1upTrigger, 31),
OBJECT_WITH_ACTS(0, -5119, -2230, 213, 0, 0, 0, 0x0,  bhvHidden1upTrigger, 31),
OBJECT_WITH_ACTS(0, 0, 0, 0, 0, 0, 0, 0x0,  bhvBirdsSoundLoop, 31),
OBJECT_WITH_ACTS(0, 0, 0, -7900, 0, 0, 0, 0x0,  bhvWaterfallSoundLoop, 31),
OBJECT_WITH_ACTS(84, -486, 5150, -40, 0, 0, 0, 0x0,  bhvBird, 31),
OBJECT_WITH_ACTS(84, 475, 5150, -49, 0, 0, 0, 0x0,  bhvBird, 31),
OBJECT_WITH_ACTS(84, -431, -1750, -275, 0, 0, 0, 0x0,  bhvBird, 31),
OBJECT_WITH_ACTS(84, 419, -1750, -266, 0, 0, 0, 0x0,  bhvBird, 31),
OBJECT_WITH_ACTS(212, 0, 9550, -2500, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, -6, 4, 9, 0, 0, 20, 10,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_castle_grounds_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(20, 6, 1, 10, 0),
WARP_NODE(21, 21, 1, 10, 0),
WARP_NODE(50, 16, 1, 0, 0),
WARP_NODE(51, 16, 1, 0, 0),
WARP_NODE(41, 16, 1, 0, 0),
WARP_NODE(22, 6, 3, 61, 0),
WARP_NODE(52, 16, 1, 0, 0),
WARP_NODE(1, 16, 1, 1, 0),
WARP_NODE(240, 16, 1, 50, 0),
WARP_NODE(241, 16, 1, 1, 0),
RETURN()
};
